<?php
$html_head = <<<htmlhead
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Moja strona WWW</title>
  </head>
  <body>
htmlhead;

$html_foot = <<<htmlfoot
  </body>
</html>
htmlfoot;

$files_list = <<<fileslist
<div>
  <ul>
    <li><a href="http://localhost/download.php?name=plik1.zip">
    Pierwszy plik</a></li>
    <li><a href="http://localhost/download.php?name=plik2.zip">
    Drugi plik</a></li>
    <li><a href="http://localhost/download.php?name=plik3.zip">
    Trzeci plik</a></li>
  </ul>
</div>
fileslist;

$nofile = <<<nofile
<p style="text-align:center">Nie ma takiego pliku na serwerze!</p>
<p style="text-align:center"> 
  <a href="http://localhost/download.html">Powrót do strony pobrań</a>
</p>
nofile;

  $filesPath = "./";

  /* funkcja sprawdzająca poprawność nazwy */
  function checkFileName($name)
  {
    if(strlen($name) > 100){
      return false;
    }
    $pliki = array(
     "plik1.zip", "plik2.zip", "plik3.zip"
    );
    return array_search($name, $pliki);
  }

  /* funkcja wysyłająca plik */
  function send($fileName, $filePath)
  {
    if(!file_exists($filePath.$fileName)){
      return false;
    }
    $fd = fopen($filePath.$fileName, "r");
    $size = filesize($filePath.$fileName);
    $contents = fread($fd, filesize($filePath.$fileName));
    if($contents === false){
      return false;
    }

    fclose($fd);

    header("Content-Type: application/octet-stream");
    header("Content-Length: $size;");
    header("Content-Disposition: attachment; filename=$fileName");

    echo $contents;
    return true;
  }

  /* odczytanie danych i wywołanie funkcji */
  if(isset($_GET['name'])){
    if(checkFileName($_GET['name']) === false){
        echo $html_head;
        echo $nofile;
        echo $html_foot;
    }
    else{
      if(!send($_GET['name'], $filesPath)){
        echo $html_head;
        echo $nofile;
        echo $html_foot;
      }
    }
  }
  else{
      echo $html_head;
      echo $files_list;
      echo $html_foot;
  }
?>
